<?php

class Extension_model extends CI_Model {

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }
 

	// original code with thrown exception:
	function do_post_request($url, $data, $optional_headers = null)
	{
		$params = array('http' => array(
				  'method' => 'POST',
				  'content' => $data
				));
		if ($optional_headers !== null) {
			$params['http']['header'] = $optional_headers;
		}
		$ctx = stream_context_create($params);
		$fp = @fopen($url, 'rb', false, $ctx);
		if (!$fp) {
			throw new Exception("Problem with $url, $php_errormsg");
		}
		$response = @stream_get_contents($fp);
		if ($response === false) {
			throw new Exception("Problem reading data from $url, $php_errormsg");
		}
		return $response;
	}

	// modded/customized
	function do_web_requests($protocol, $url, $method, $data, $optional_headers = null)
	{ 
		if (strtoupper($method) == "GET") {
			$url = $url.http_build_query($data);
			$params = array($protocol => array(
					  'method' => strtoupper($method),
					));
		}
		else {
			$params = array($protocol => array(
					  'method' => strtoupper($method),
					  'content' => http_build_query($data)
					));
		}
		if ($optional_headers !== null) {
			$params['http']['header'] = $optional_headers;
		}
		
		$ctx = stream_context_create($params);
		$fp = @fopen($url, 'rb', false, $ctx);
		
		if (!$fp) {
			$response = false;
		}
		else {
			$response = @stream_get_contents($fp);
		}
		return $response;
	}	

	function do_http_post_request($url, $data, $optional_headers = null)
	{ 
		return $this->do_web_requests('http', $url, 'POST', $data, $optional_headers);
	}
	
	function do_https_post_request($url, $data, $optional_headers = null)
	{ 
		return $this->do_web_requests('https', $url, 'POST', $data, $optional_headers);
	}
	
	function do_http_get_request($url, $data, $optional_headers = null)
	{
		return $this->do_web_requests('http', $url, 'GET', $data, $optional_headers);
	}
	
	function do_https_get_request($url, $data, $optional_headers = null)
	{
		return $this->do_web_requests('https', $url, 'GET', $data, $optional_headers);
	}
	
	function get_transaction_bcode($tid = false) {
		if (!$tid) { return false; }
		
		$this->db->where('bcode_transaction_id', $tid);
		$this->db->select('bcode_value');
		$query = $this->db->get('bcode')->row();
		
		return empty($query->bcode_value)? false: $query->bcode_value;
		
		
	}
	
	function __getbcode($data = array()) {
 		$url = $this->config->item('bcode_url');
		$xmldata = $this->do_https_get_request($url,$data);
		$this->load->library('simplexml');  
		return $this->simplexml->xml_parse($xmldata); 
	}
	
	function __sendbcodesms($data = array()) {
 		$url = $this->config->item('bcode_sms');
		$xmldata = $this->do_https_get_request($url,$data);
		$this->load->library('simplexml');  
		return $this->simplexml->xml_parse($xmldata); 
	}	
	
	function __bcodeparams($manual = false) {
		$data = array(
			'user' => $this->config->item('bcode_user'),
			'password' => $this->config->item('bcode_pass'),
			'application' => $this->config->item('bcode_app'),
		);

	}
	
}

